package structure;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

/**
 * Implementiert eine Bilddatendatei, die die vier Kanle Rot, Grn, Blau und Infrarot untersttzt. 
 * Zur Erzeugung muss ein RGB-Bild und ein Grauwert-Bild des Infrarotbereichs geladen werden.
 * 
 * @version 1.0 vom 20.10.2021
 * @author Nico Kraft, Ruhr-Universitt Bochum, Nico.Kraft@rub.de
 */
public class RGBI_Image {
	
	BufferedImage RGB;
	int[][] IR;

	public RGBI_Image(String RGBImagePath, String IRImagePath) {
		LoadRGBImage(RGBImagePath);
		LoadIRImage(IRImagePath);
		
		if(RGB.getHeight() * RGB.getWidth() == IR.length * IR[0].length)
			System.out.println("Texturgre gleich!");
		else
			System.err.println("Ungleiche Texturgre!");
	
	}
	
	private void LoadRGBImage(String path)
	{
		try {
	        RGB = ImageIO.read(new File(path));
	    } catch (IOException e) {
	    	System.err.println("Image not found!");
	    }
	}
	private void LoadIRImage(String path)
	{
		BufferedImage tmp = null;
		try {
	        tmp = ImageIO.read(new File(path));
	    } catch (IOException e) {
	    	System.err.println("Image not found!");
	    }
		
		IR = new int[tmp.getWidth()][tmp.getHeight()];
		
		for(int y = 0; y < tmp.getHeight(); y++)
		{
			for(int x = 0; x < tmp.getWidth(); x++)
			{
				Color color = new Color(tmp.getRGB(x, y));
				IR[x][y] = color.getRed();
			}
		}
	}
	
	/**
	 * Gibt Wert des Rotkanals an der Stelle (x,y) zurck.
	 * @param x Position auf X-Achse.
	 * @param y Position auf Y-Achse.
	 * @return Wert des Kanals.
	 */
	public int getRed(int x, int y)
	{
		return new Color(RGB.getRGB(x, y)).getRed();
	}
	
	/**
	 * Gibt Wert des Grnkanals an der Stelle (x,y) zurck.
	 * @param x Position auf X-Achse.
	 * @param y Position auf Y-Achse.
	 * @return Wert des Kanals.
	 */
	public int getGreen(int x, int y)
	{
		return new Color(RGB.getRGB(x, y)).getGreen();
	}
	
	/**
	 * Gibt Wert des Blaukanals an der Stelle (x,y) zurck.
	 * @param x Position auf X-Achse.
	 * @param y Position auf Y-Achse.
	 * @return Wert des Kanals.
	 */
	public int getBlue(int x, int y)
	{
		return new Color(RGB.getRGB(x, y)).getBlue();
	}
	
	/**
	 * Gibt Wert des Infrarotkanals an der Stelle (x,y) zurck.
	 * @param x Position auf X-Achse.
	 * @param y Position auf Y-Achse.
	 * @return Wert des Kanals.
	 */
	public int getInfrared(int x, int y)
	{
		return IR[x][y];
	}
	
	public BufferedImage getRGBImage()
	{
		return RGB;
	}
	
	public int getWidth()
	{
		return RGB.getWidth();
	}
	public int getHeight()
	{
		return RGB.getHeight();
	}

}
