package view;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.*;

import structure.RGBI_Image;


/**
 *
 * Verarbeitung einer Satellitenaufnahme und Anzeige des entsprechenden NDVI-Bildes.
 *
 * @version 1.0 vom 20.10.2021
 * @author Nico Kraft, Ruhr-Universitt Bochum, Nico.Kraft@rub.de
 */

public class GUI extends JFrame {
  // Anfang Attribute
  private JPanel MainPanel = new JPanel(null, true);
    private JLabel LabelMainPicture = new JLabel();
    RGBI_Image input;
    BufferedImage output;
    private ImageIcon inputIcon;
    
  RGBI_Image RGBI;
  // Ende Attribute
  
  public GUI() { 
    // Frame-Initialisierung
    super();
    
    input = new RGBI_Image("images/DESIS_RGB.png", "images/DESIS_IR.png");
    try {
        output = ImageIO.read(new File("images/DESIS_RGB.png"));
    } catch (Exception e) {
    	System.out.println("Image not found!");
    }
    
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = input.getWidth(); 
    int frameHeight = input.getHeight();
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("NDVI");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    MainPanel.setBounds(0, 0, input.getWidth(), input.getHeight());
    //MainPanel.setOpaque(false);
    MainPanel.setEnabled(true);
    MainPanel.setVisible(true);
    cp.add(MainPanel);
    LabelMainPicture.setBounds(0, 0, input.getWidth(), input.getHeight());
    inputIcon = new ImageIcon(input.getRGBImage());
    MainPanel.add(LabelMainPicture);
    
    LabelMainPicture.setVisible(true);
    setVisible(true);
    
    NDVI();
  } // end of public gui
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new GUI();
  } // end of main
  
  /**
   * Erzeugt ein NDVI-Bild
   */
  public void NDVI()
  {
	  //////////Code hier vervollstndigen: Erzeugung des NDVI-Bilds (Auslesen der Bilddaten input, Anwenden der Formel und Setzen der neuen Bilddaten output)  
	  
	  
	  /////////
	  SetImage(output);
  }

  /**
   * Gibt bei Angabe eines NDVI-Werts die entsprechende Farbe zurck.
   * @param ndvi NDVI-Wert zwischen -1 und 1.
   * @return Farbwert des NDVI-Werts.
   */
  private Color NDVI_Filter(float ndvi)
  {
	  //Ungltiger NDVI-Wert
	  if(ndvi < -1f || ndvi > 1f)
		  return new Color(0,0,0);
	  
	  int red = 255;
	  int green = 255;
	  
	  if(ndvi < 0)
	  {
		  green = (int)( (ndvi + 1f) * 255f);
	  }
	  else
	  {
		  red = (int)( 255f - (ndvi * 255f));
		  green = (int)( 255f - ((ndvi * 255f) / 2));
	  }
	  
	  return new Color((int)red, (int)green, (int)0);
  }
  
  private void SetImage(BufferedImage image)
  {
	  inputIcon = new ImageIcon(image);
	  LabelMainPicture.setIcon(inputIcon);
  }


  // Ende Methoden
} // end of class gui
